import java.util.function.ToIntFunction;

class Umgebungen {
    static java.util.List<String> ls = java.util.Arrays.asList("1", "22", "333");
    static String statEnv = "Stat";
    String instEnv = "Inst";

    // Objekt einer anonymen Klasse (OAK) in einem statischen Feld
    static ToIntFunction<String> stoiAnonS = new ToIntFunction<>() {
        @Override
        public int applyAsInt(String s) {
            // Zugriff auf eine statische Variable
            return (statEnv+s).length();
        }
    };

    void instMeth() {
        String methEnv = "Meth";
        // Objekt einer anonymen Klasse (OAK) in einer lokalen Variablen einer Instanzmethode
        var stoiAnonIM = new ToIntFunction<String>() {
            @Override
            public int applyAsInt(String s) {
                // Zugriff auf eine stat. Variable, eine Instanzvariable und eine lokale Variable
                return (statEnv+instEnv+methEnv+s).length();
            }
        };
        IO.println("\nOAK in umgebender Instanzmethode: " +
                   ls.stream().mapToInt(stoiAnonIM).sum());
    }

    static void main() {
        String methEnv = "Meth";

        // Objekt einer anonymen Klasse (OAK) in einer lokalen Variablen einer statischen Methode
        var stoiAnonSM = new ToIntFunction<String>() {
            @Override
            public int applyAsInt(String s) {
                // Zugriff auf eine statische Variable und eine lokale Variable
                return (statEnv+methEnv+s).length();
            }
        };

        IO.println("OAK mit statischem Kontext:       " +
                   ls.stream().mapToInt(stoiAnonS).sum());
        IO.println("\nOAK in umgebender stat. Methode:  " +
                   ls.stream().mapToInt(stoiAnonSM).sum());

        var u = new Umgebungen();
        u.instMeth();
    }
}